require( "quest/m2_vcr/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talke",
	"anim/flo/talkw",
	"anim/flo/walke",
	"anim/flo/walkw",
};

flo_spec =
{
	name = "FLO"; point_at_name = "obj_flo";
	--halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:JumpToNamedPoint("flo");
		actor:Face(DIR.E);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		actor:SetAlpha(0);
		BAG_INV:RemoveInventory("vhstape");		
		wait_fade();
		
		sfx:PlaySFX("audio/sfx/gym_vcr");
		
		delay(60);
		
		--video_title_spec,
		scene:Spawn(derek_spec);
		scene:Spawn(tv_reflection_spec);
		scene:Spawn(cake_machine_bg_spec);
		scene:Spawn(cake_machine_spec);
		coroutine.yield(RESUME.NOW);
		
		delay(60);
		
		run_super_conversation(actor, "conv_derek");
		actor:SetMode(MODE.FOLLOWCLICKS);
		scene:Spawn(back_spec);
	end;
};

derek_spec = 
{
	name = "DEREK";
	--halo = "quest/objects/derekw";
	gfx = { anim = "anim/m2_vcr/derek" };
	
	command = function(actor)
		prepare_actor_text(actor, derek_text_spec);
		actor:ModifySaySpec { mouth_in_actor = { x = 508, y = 302 }, bubble_0 = bubble_b0_spec, bubble_1 = bubble_b1_spec, bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEFLIP + BUBBLE.BUBBLE_AUTOVFLIP };
		actor:SetDepthValue(20);
		actor:FaceNow(DIR.S);
	end;
};

cake_machine_spec = 
{
	name = "CAKE_MACHINE";
	gfx = { anim = "anim/m2_vcr/cake_machine" };
	
	command = function(actor)
		actor:SetDepthValue(25);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Closed");
	end;
}

cake_machine_bg_spec = 
{
	name = "CAKE_MACHINE_BG";
	gfx = { image = "tv_cake_machine_bg" };
	
	command = function(actor)
		actor:SetDepthValue(10);
	end;
};

tv_reflection_spec = 
{
	name = "TV_REFLECTION";
	gfx = { image = "tv_reflection_overlay" };
	
	command = function(actor)
		actor:SetDepthValue(100);
	end;
}

video_title_spec = 
{
	name = "VIDEO_TITLE";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
		actor:AddFlag(AFLAG.AFLAG_FIXED_SCREEN);
		actor:ModifySaySpec
		{
			--font = "fonts/wiesbadenswing.mvec",
			x = 200,
			y = 35,
			lineheight = 25,
			color = { a = 1, r = 0, g = 0, b = 0 },
			outline_size = 0,
			bubble = false,
			anchor = ANCHOR.TOP,
			halign = HALIGN.CENTER,
			w = 400,
			h = 100,
			linepadding = -5
		}
		
		--actor:SetAlpha(0.7);
		
		actor:Say("text_video_title");
	end;
}

video_buttons_spec = 
{
	name = "VIDEO_BUTTONS";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
		actor:AddFlag(AFLAG.AFLAG_FIXED_SCREEN);
		actor:ModifySaySpec
		{
			--font = "fonts/wiesbadenswing.mvec",
			x = 200,
			y = 340,
			lineheight = 25,
			color = { a = 1, r = 0, g = 0, b = 0 },
			outline_size = 0,
			bubble = false,
			anchor = ANCHOR.TOP,
			halign = HALIGN.CENTER,
			w = 400,
			h = 100,
			linepadding = -5
		}
		
		--actor:SetAlpha(0.7);
		
		actor:Say("text_video_buttons");
	end;
}

function show_buttons()
	sfx:PlaySFX( "audio/sfx/cake_machine_button", false );
	scene.CAKE_MACHINE:PlayAnim("One");
	wait_anim(scene.CAKE_MACHINE);
	
	sfx:PlaySFX( "audio/sfx/cake_machine_button", false );
	scene.CAKE_MACHINE:PlayAnim("One");
	wait_anim(scene.CAKE_MACHINE);
	
	sfx:PlaySFX( "audio/sfx/cake_machine_button", false );
	scene.CAKE_MACHINE:PlayAnim("Two");
	wait_anim(scene.CAKE_MACHINE);
	
	sfx:PlaySFX( "audio/sfx/cake_machine_button", false );
	scene.CAKE_MACHINE:PlayAnim("Two");
	wait_anim(scene.CAKE_MACHINE);
	
	sfx:PlaySFX( "audio/sfx/cake_machine_button", false );
	scene.CAKE_MACHINE:PlayAnim("Three");
	wait_anim(scene.CAKE_MACHINE);
	
	sfx:PlaySFX( "audio/sfx/cake_machine_button", false );
	scene.CAKE_MACHINE:PlayAnim("Three");
	wait_anim(scene.CAKE_MACHINE);
	
	sfx:PlaySFX( "audio/sfx/cake_machine_button", false );
	scene.CAKE_MACHINE:PlayAnim("Two");
	wait_anim(scene.CAKE_MACHINE);
	
	sfx:PlaySFX( "audio/sfx/cake_machine_button", false );
	scene.CAKE_MACHINE:PlayAnim("Two");
	wait_anim(scene.CAKE_MACHINE);
	
	sfx:PlaySFX( "audio/sfx/cake_machine_button", false );
	scene.CAKE_MACHINE:PlayAnim("One");
	wait_anim(scene.CAKE_MACHINE);
	
	sfx:PlaySFX( "audio/sfx/cake_machine_button", false );
	scene.CAKE_MACHINE:PlayAnim("One");
	wait_anim(scene.CAKE_MACHINE);
end

function show_cake()
	sfx:PlaySFX( "audio/sfx/cake_machine_work", false );
	scene.CAKE_MACHINE:PlayAnim("Open");
	wait_anim(scene.CAKE_MACHINE);
	scene.CAKE_MACHINE:PlayAnim("Cake");
	wait_anim(scene.CAKE_MACHINE);
end
	

back_spec = 
{
	name = "BACK";
	halo = "background";
	--point_at_name = "back";
	--point_at_color = { a  = 1, r = 1, g = 0, b = 0 };
	
	command = function(actor)
		actor:SetDepthValue(0);
		actor:SetPointAtCursor("cursor_exit");
	end;
	
	on_arrive = function(flo, actor)
		scene:ReturnFromScene();
	end;
	
	on_use_inv = function(item, flo, actor)
		return RESPONSE.INV_HANDLED;
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		--sfx:SetMusic("audio/music/office.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
		end
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "red", 5 },
		--{ "green", 5 },
		--{ "blue", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		
		scene_setup,
	};
};
